/************************************************************************
*
* Copyright:
*	Freescale Semiconductor, INC. All Rights Reserved.  
*  You are hereby granted a copyright license to use, modify, and
*  distribute the SOFTWARE so long as this entire notice is
*  retained without alteration in any modified and/or redistributed
*  versions, and that such modified versions are clearly identified
*  as such. No licenses are granted by implication, estoppel or
*  otherwise under any patents or trademarks of Freescale Semiconductor, 
*  Inc. This software is provided on an "AS IS" basis and without warranty.
*
*  To the maximum extent permitted by applicable law, FREESCALE 
*  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
*  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
*  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
*  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
*  ACCOMPANYING WRITTEN MATERIALS.
* 
*  To the maximum extent permitted by applicable law, IN NO EVENT
*  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
*  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
*  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
*  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
* 
*  Freescale assumes no responsibility for the maintenance and support
*  of this software
*************************************************************************
*
*  FILE NAME: fft16.h
*
*  PURPOSE: header file for fft16 module
*           contains constants definition and functions prototypes  
*
*  AUTHORS: Anatoly Khaynakov and Andriy Tymkiv
*
************************************************************************/
#ifndef __FFT_16_H
#define  __FFT_16_H

void  init_data16 (void *,void *);
void  fft16_emac (void *, void *);
void  fft16_mac (void *, void *);
void  inv_fft16_emac (void *, void *);
void  inv_fft16_mac (void *, void *);

#ifdef __EMAC
	#define fft16(x,y)		fft16_emac(x,y)
	#define inv_fft16(x,y)	inv_fft16_emac(x,y)
#else
	#define fft16(x,y)		fft16_mac(x,y)
	#define inv_fft16(x,y)	inv_fft16_mac(x,y)
#endif

#endif //__FFT_16_H
